/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsValidation;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkSettings5Bean
extends WizardTaskBean
implements NetworkSettingsConstants {
    public static final String BEAN_NAME = "NetworkSettings5Bean";
    private static final String TRACE_MASKD = "JNSWNS5D";
    private static final String TRACE_MASKF = "JNSWNS5F";
    private static final String TRACE_MASKT = "JNSWNS5T";
    static final short ERRID_0001 = 1;
    static final short ERRID_0002 = 2;
    static final short ERRID_0003 = 3;
    static final short ERRID_0004 = 4;
    static final short ERRID_0005 = 5;
    static ClassLogInfo LOG_INFO = new ClassLogInfo(-88, 126, "NetSet5Bean");
    private static final String AUTOMATIC_IPADDRESS = "RadioButton1";
    private static final String SPECIFIED_IPADDRESS = "RadioButton2";
    private static final String INTERFACE_ADDRESS = "InterfaceAddress";
    private static final String NETWORK_MASK = "NetworkMask";
    private String[] m_sObtainIPAddressAutomaticallySelection;
    private String m_sInterfaceAddress;
    private String m_sNetworkMask;
    private boolean m_bAutomaticIPAddress;
    private int m_iAddressType;
    private boolean m_bUpdateError;
    private boolean m_bChangeFlag;
    private boolean m_bChangedSinceLastUpdate;

    public NetworkSettings5Bean() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean Default Constructor");
        }
        this.m_sObtainIPAddressAutomaticallySelection = new String[0];
        this.m_sInterfaceAddress = "";
        this.m_sNetworkMask = "";
        this.m_iAddressType = 3;
        this.m_bAutomaticIPAddress = false;
        this.m_bUpdateError = false;
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
        this.setBeanName(BEAN_NAME);
    }

    public NetworkSettings5Bean(NetworkSettings5Bean networkSettings5Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean NetworkSettings5Bean Constructor");
        }
        this.bean5Copy(networkSettings5Bean);
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
    }

    public NetworkSettings5Bean(NetworkSettings5Bean networkSettings5Bean, boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean NetworkSettings5Bean Constructor - preserve change flag");
        }
        this.bean5Copy(networkSettings5Bean);
        this.m_bChangeFlag = networkSettings5Bean.isChanged();
        this.m_bChangedSinceLastUpdate = networkSettings5Bean.isChangedSinceLastUpdate();
    }

    public NetworkSettings5Bean(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean Object Constructor");
        }
        String string = ((PanelBean)object).getBeanName();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean Object passed is: " + string);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(BEAN_NAME)) {
                this.bean5Copy((NetworkSettings5Bean)object);
                this.m_bChangeFlag = ((NetworkSettings5Bean)object).isChanged();
                this.m_bChangedSinceLastUpdate = ((NetworkSettings5Bean)object).isChangedSinceLastUpdate();
            } else {
                this.m_sObtainIPAddressAutomaticallySelection = new String[0];
                this.m_sInterfaceAddress = "";
                this.m_sNetworkMask = "";
                this.m_iAddressType = 3;
                this.m_bAutomaticIPAddress = false;
                this.m_bUpdateError = false;
                this.m_bChangeFlag = false;
                this.m_bChangedSinceLastUpdate = false;
                this.setBeanName(BEAN_NAME);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean ERROR - incorrect object passed on object constructor:" + string);
                }
                new AusMicrocodeLog(LOG_INFO, 2, new Exception(string)).writeEntryFromTaskletClient();
            }
        } else {
            this.m_sObtainIPAddressAutomaticallySelection = new String[0];
            this.m_sInterfaceAddress = "";
            this.m_sNetworkMask = "";
            this.m_iAddressType = 3;
            this.m_bAutomaticIPAddress = false;
            this.m_bUpdateError = false;
            this.m_bChangeFlag = false;
            this.m_bChangedSinceLastUpdate = false;
            this.setBeanName(BEAN_NAME);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean ERROR - incorrect object passed on object constructor");
            }
            new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
        }
    }

    private void bean5Copy(NetworkSettings5Bean networkSettings5Bean) {
        this.m_sObtainIPAddressAutomaticallySelection = networkSettings5Bean.getObtainIPAddressAutomaticallySelection();
        this.m_sInterfaceAddress = networkSettings5Bean.getInterfaceAddress();
        this.m_sNetworkMask = networkSettings5Bean.getNetworkMask();
        this.m_iAddressType = networkSettings5Bean.getAddressType();
        this.m_bAutomaticIPAddress = networkSettings5Bean.isAutomaticIPAddress();
        this.setBeanName(networkSettings5Bean.getBeanName());
    }

    public void setObtainIPAddressAutomaticallySelection(String[] stringArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setObtainIPAddressAutomaticallySelection(" + stringArray[0] + ")");
        }
        this.m_sObtainIPAddressAutomaticallySelection = stringArray;
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
        boolean bl = false;
        if (this.m_sObtainIPAddressAutomaticallySelection.length > 0) {
            this.m_sObtainIPAddressAutomaticallySelection[0] = this.m_sObtainIPAddressAutomaticallySelection[0].trim();
            if (this.m_sObtainIPAddressAutomaticallySelection[0].endsWith(AUTOMATIC_IPADDRESS)) {
                bl = true;
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean setObtainIPAddressAutomaticallySelection called setting AutomaticIPAddress = " + bl);
        }
        this.m_bAutomaticIPAddress = bl;
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean setObtainIPAddressAutomaticallySelection isAutomaticIPAddress = " + this.isAutomaticIPAddress());
        }
        if (this.userTaskManager != null && this.getMountPrefix() != null) {
            if (this.isAutomaticIPAddress()) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, false);
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, true);
            }
        }
    }

    public String[] getObtainIPAddressAutomaticallySelection() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean getObtainIPAddressAutomaticallySelection called");
        }
        return this.m_sObtainIPAddressAutomaticallySelection;
    }

    public void setInterfaceAddress(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setInterfaceAddress(" + string + ")");
        }
        this.m_sInterfaceAddress = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getInterfaceAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean getInterfaceAddress called");
        }
        return this.m_sInterfaceAddress;
    }

    public void setNetworkMask(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setNetworkMask(" + string + ")");
        }
        this.m_sNetworkMask = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getNetworkMask() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean getNetworkMask called");
        }
        return this.m_sNetworkMask;
    }

    public boolean getAutomaticIPAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean getAutomaticIPAddress called");
        }
        return this.m_bAutomaticIPAddress;
    }

    public void setAutomaticIPAddress(boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setAutomaticIPAddress called AutomaticIPAddress = " + bl);
        }
        this.m_bAutomaticIPAddress = bl;
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public int getAddressType() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean getAddressType called AddressType = " + this.m_iAddressType);
        }
        return this.m_iAddressType;
    }

    public void setAddressType(int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setAddressType called AddressType = " + n);
        }
        this.m_iAddressType = n;
    }

    public boolean isUpdateError() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean isUpdateError returning " + this.m_bUpdateError);
        }
        return this.m_bUpdateError;
    }

    public boolean isChanged() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean isChanged returning " + this.m_bChangeFlag);
        }
        return this.m_bChangeFlag;
    }

    public boolean isChangedSinceLastUpdate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean isChangedSinceLastUpdate returning " + this.m_bChangedSinceLastUpdate);
        }
        return this.m_bChangedSinceLastUpdate;
    }

    public boolean isAutomaticIPAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean isAutomaticIPAddress called returning = " + this.m_bAutomaticIPAddress);
        }
        return this.m_bAutomaticIPAddress;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean load called");
        }
        this.m_sObtainIPAddressAutomaticallySelection = new String[1];
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean load isAutomaticIPAddress = " + this.isAutomaticIPAddress());
        }
        this.m_sObtainIPAddressAutomaticallySelection[0] = this.isAutomaticIPAddress() ? new String(this.getMountPrefix() + AUTOMATIC_IPADDRESS) : new String(this.getMountPrefix() + SPECIFIED_IPADDRESS);
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean nextButtonHit called");
        }
        if (!this.isAutomaticIPAddress()) {
            if (!(this.m_sInterfaceAddress != null && this.m_sInterfaceAddress.trim().length() > 0 || this.m_sNetworkMask != null && this.m_sNetworkMask.trim().length() > 0)) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean nextButtonHit generating WizardTaskException - address and mask missing ");
                }
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1082", null));
            }
            if (this.m_sInterfaceAddress == null || this.m_sInterfaceAddress.trim().length() <= 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean nextButtonHit generating WizardTaskException - address missing ");
                }
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1083", null));
            }
            if (this.m_sNetworkMask == null || this.m_sNetworkMask.trim().length() <= 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean nextButtonHit generating WizardTaskException - mask missing ");
                }
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1084", null));
            }
            int n = NetworkSettingsValidation.validateIPAddress(this.m_sInterfaceAddress);
            if (n != 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean nextButtonHit generating WizardTaskException - interface address invalid- validateIPAddress rc = " + n);
                }
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1049", null));
            }
            int n2 = NetworkSettingsValidation.validateNetworkMask(this.m_sNetworkMask);
            if (n2 != 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean nextButtonHit generating WizardTaskException - network mask invalid- validateNetworkMask rc = " + n2);
                }
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1050", null));
            }
        }
        return new NetworkSettings5Bean((Object)this);
    }

    public Serializable backButtonHit() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean backButtonHit called");
        }
        return new NetworkSettings5Bean((Object)this);
    }

    public void updateBean(NetworkSettings5Bean networkSettings5Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean updateBean called");
        }
        if (networkSettings5Bean.isChangedSinceLastUpdate() && networkSettings5Bean.getObtainIPAddressAutomaticallySelection().length > 0) {
            this.setObtainIPAddressAutomaticallySelection(networkSettings5Bean.getObtainIPAddressAutomaticallySelection());
            this.setAutomaticIPAddress(networkSettings5Bean.getAutomaticIPAddress());
            this.setInterfaceAddress(networkSettings5Bean.getInterfaceAddress());
            this.setNetworkMask(networkSettings5Bean.getNetworkMask());
        }
    }

    public void setNetworkInterfaceInformation(NetworkInterfaceInformation networkInterfaceInformation) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean setNetworkInterfaceInformation called");
        }
        if (networkInterfaceInformation.getIpAddr() != null && networkInterfaceInformation.getIpAddr().length() > 0) {
            this.m_sInterfaceAddress = networkInterfaceInformation.getIpAddr();
        }
        if (networkInterfaceInformation.getNetMask() != null && networkInterfaceInformation.getNetMask().length() > 0) {
            this.m_sNetworkMask = networkInterfaceInformation.getNetMask();
        }
        this.m_bAutomaticIPAddress = networkInterfaceInformation.isDhcpClient();
    }

    public void updateNetworkInterfaceInformation(NetworkInterfaceInformation networkInterfaceInformation) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean updateNetworkInterfaceInformation called");
        }
        if (this.isChangedSinceLastUpdate()) {
            networkInterfaceInformation.setDhcpClient(this.isAutomaticIPAddress());
            if (!this.isAutomaticIPAddress()) {
                this.m_bUpdateError = false;
                try {
                    if (this.getInterfaceAddress().length() > 0) {
                        networkInterfaceInformation.setIpAddress(InetAddress.getByName(this.getInterfaceAddress()));
                    }
                    if (this.getNetworkMask().length() > 0) {
                        networkInterfaceInformation.setNetworkMask(InetAddress.getByName(this.getNetworkMask()));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.m_bUpdateError = true;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean updateNetworkInterfaceInformation UnknownHostException = " + unknownHostException);
                    }
                    new AusMicrocodeLog(LOG_INFO, 4, unknownHostException).writeEntryFromTaskletClient();
                }
            }
            this.m_bChangedSinceLastUpdate = false;
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent != null) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO, 1).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-NetworkSettings5Bean panelAction(...)");
        }
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings5Bean prepare called");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean prepare getMountPrefix = " + this.getMountPrefix());
        }
        this.m_sObtainIPAddressAutomaticallySelection = new String[1];
        switch (this.m_iAddressType) {
            case 0: {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "->NetworkSettings5Bean prepare Fixed ");
                }
                this.m_sObtainIPAddressAutomaticallySelection[0] = new String(this.getMountPrefix() + SPECIFIED_IPADDRESS);
                this.userTaskManager.setEnabled(this.getMountPrefix() + AUTOMATIC_IPADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + SPECIFIED_IPADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, true);
                this.m_bAutomaticIPAddress = false;
                if (this.isChanged()) break;
                this.m_bChangeFlag = true;
                this.m_bChangedSinceLastUpdate = true;
                break;
            }
            case 1: {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "->NetworkSettings5Bean prepare DHCP Client");
                }
                this.m_sObtainIPAddressAutomaticallySelection[0] = new String(this.getMountPrefix() + AUTOMATIC_IPADDRESS);
                this.userTaskManager.setEnabled(this.getMountPrefix() + AUTOMATIC_IPADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + SPECIFIED_IPADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, false);
                this.m_bAutomaticIPAddress = true;
                if (this.isChanged()) break;
                this.m_bChangeFlag = true;
                this.m_bChangedSinceLastUpdate = true;
                break;
            }
            case 2: {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean prepare DHCP Server ");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean prepare DHCP Server SHOULD NEVER GET HERE - ERROR");
                }
                this.m_sObtainIPAddressAutomaticallySelection[0] = new String("");
                this.userTaskManager.setEnabled(this.getMountPrefix() + AUTOMATIC_IPADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + SPECIFIED_IPADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, false);
                this.m_bChangeFlag = false;
                this.m_bChangedSinceLastUpdate = false;
                new AusMicrocodeLog(LOG_INFO, 5).writeEntryFromTaskletClient();
                break;
            }
            default: {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean prepare customer choice and default ");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings5Bean prepare isAutomaticIPAddress = " + this.isAutomaticIPAddress());
                }
                if (this.isAutomaticIPAddress()) {
                    this.m_sObtainIPAddressAutomaticallySelection[0] = new String(this.getMountPrefix() + AUTOMATIC_IPADDRESS);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, false);
                    break;
                }
                this.m_sObtainIPAddressAutomaticallySelection[0] = new String(this.getMountPrefix() + SPECIFIED_IPADDRESS);
                this.userTaskManager.setEnabled(this.getMountPrefix() + INTERFACE_ADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + NETWORK_MASK, true);
            }
        }
    }
}

